/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_PATCHING_INTERFACE_H
#define _SCE_PATCHING_INTERFACE_H

#include "np_toolkit_defines.h"

namespace sce {
	namespace Toolkit{
		namespace NP{

			/// @brief
			/// The namespace containing patching functionality.
			///	
			/// The namespace containing patching functionality.
			namespace Patching {

			/// @brief
			/// The patching interface allows users to check for the existence of a patch.
			///
			/// The patching interface allows users to check for the existence of a patch. This can then be downloaded and applied
			/// if the user agrees after being presented with a message dialogue.
			class Interface
			{
			public:

				/// @brief
				/// Checks for existence of a new patch and asks the user whether to apply it.
				///
				/// Checks for existence of a new patch and asks the user whether to apply it.
				/// This function uses the game update utility to carry out the patch checking and application
				/// procedure.
				/// 
				/// @retval				SCE_TOOLKIT_NP_SUCCESS				The operation was successful.	
				/// @retval				SCE_TOOLKIT_NP_NOT_INITIALISED		The operation  failed because the %NP %Toolkit library was not initialized.
				static int checkForPatch();

			};

			}//end Patching
		}//end NP
	}//end Toolkit
}//end Sce
#endif
